unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, AGASPEECHCTRLLib_TLB;

type
  TForm1 = class(TForm)
    Button1: TButton;
    ListBox1: TListBox;
    Button2: TButton;
    Memo1: TMemo;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    FSpeech: TAASpeechCtrl;
    FSpeechVoice: Integer;
    FSpeechVoiceID: Integer;
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

const
  EAS_NOT_CONNECTED = $800a0258;
  EAS_NOT_ENOUGH_MEMORY = $800a0260;
  EAS_SRV_NOTRUNNING = $800a0273;


procedure TForm1.FormCreate(Sender: TObject);
begin
  FSpeech := TAASpeechCtrl.Create(self);
  if FSpeech.ConnectEngine(1, 0, '') <> 0 then
    raise Exception.Create('Unable to connect to the API');
  FSpeechVoice := -1;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  FSpeech.Unload;
  FSpeech.DisconnectEngine;
  FreeAndNil(FSpeech);
end;

procedure TForm1.Button1Click(Sender: TObject);
var
 i: Integer;
begin
  case FSpeech.Enumerate of
    EAS_NOT_CONNECTED:
      raise Exception.Create('API Not connected');

    EAS_NOT_ENOUGH_MEMORY:
      raise Exception.Create('Not enough memory');

    EAS_SRV_NOTRUNNING:
      raise Exception.Create('SRV Not Running');
  end;
  for i:=0 to FSpeech.VoiceCount-1 do
    ListBox1.Items.Add(FSpeech.Voice[i].Speaker);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  if ListBox1.ItemIndex = -1 then
    raise Exception.Create('Please select a voice first');
  if FSpeechVoice <> ListBox1.ItemIndex then
  begin
    if FSpeechVoice <> -1 then
      FSpeech.Unload;
    FSpeechVoice := ListBox1.ItemIndex;
    FSpeechVoiceID := FSpeech.Load(FSpeech.Voice[FSpeechVoice].Cmd);
  end;
  FSpeech.Speak(Memo1.Text, FSpeechVoiceID);
end;

end.
